class SpawnProtector extends UDamage;

var texture	DMtexture,
		RedTeamTexture,
		BlueTeamTexture,
		GreenTeamTexture,
		GoldTeamTexture;

var byte	bLightRadius;

var sound	ExpireSound;

function SetOwnerLighting()
{
	if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
		&& (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) ) 
		return;
	Owner.AmbientGlow = 254;
	if ( Level.Game.bTeamGame )
			{
			if ( Pawn(Owner).PlayerReplicationInfo.Team == 0)
				{
				Owner.LightBrightness=64;
				Owner.LightHue=255;
				Owner.LightSaturation=127;
				}
			else if ( Pawn(Owner).PlayerReplicationInfo.Team == 1)
				{
				Owner.LightBrightness=64;
				Owner.LightHue=170;
				Owner.LightSaturation=127;
				}
			else if ( Pawn(Owner).PlayerReplicationInfo.Team == 2)
				{
				Owner.LightBrightness=64;
				Owner.LightHue=85;
				Owner.LightSaturation=64;
				}
			else
				{
				Owner.LightBrightness=64;
				Owner.LightHue=42;
				Owner.LightSaturation=127;
				}
			}
		else
			{
			Owner.LightBrightness=64;
			Owner.LightHue=0;
			Owner.LightSaturation=192;
			} 
	Owner.LightEffect=LE_NonIncidence;
	Owner.LightRadius=bLightRadius;
	Owner.LightType=LT_Steady;
}

state Activated
{
	function Timer()
	{

		if ( Charge > 0 )
		{
			Charge--;
//			if ( Pawn(Owner).Health < 100 )
//				{
//				Pawn(Owner).Health = 100;
//				}
			Pawn(Owner).bProjTarget = False;
			return;
		}
		Pawn(Owner).ReducedDamageType = '';
		Owner.SetDefaultDisplayProperties();
		Pawn(Owner).PlaySound(ExpireSound,,2.5);
		Pawn(Owner).bProjTarget = True;
		UsedUp();
	}

	function SetOwnerDisplay()
	{
		if( Inventory != None )
			Inventory.SetOwnerDisplay();
	}

	function ChangedWeapon()
	{
		if( Inventory != None )
			Inventory.ChangedWeapon();
	}

	function EndState()
	{
		UsedUp();
	}

	function BeginState()
	{
		bActive = true;
		SetTimer(1.0,True);
		Owner.PlaySound(ActivateSound);	
		SetOwnerLighting();
		Pawn(Owner).DamageScaling = 0.0;
		Pawn(Owner).ReducedDamageType = 'All';
		if ( Level.Game.bTeamGame )
			{
			if ( Pawn(Owner).PlayerReplicationInfo.Team == 0)
				{
				Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,RedTeamTexture,true,true);
				}
			else if ( Pawn(Owner).PlayerReplicationInfo.Team == 1)
				{
				Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,BlueTeamTexture,true,true);
				}
			else if ( Pawn(Owner).PlayerReplicationInfo.Team == 2)
				{
				Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,GreenTeamTexture,true,true);
				}
			else
				{
				Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,GoldTeamTexture,true,true);
				}
			}
		else
			{
				Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,DMtexture,true,true);
			}
	}
}

defaultproperties
{
     bLightRadius=10
     bAutoActivate=True
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="Don't shoot at spawners!!"
     ItemName="SpawnProtector"
     RespawnTime=0.000000
     PickupViewMesh=LodMesh'Botpack.UDamage'
     Charge=300
     MaxDesireability=2.500000
     PickupSound=Sound'Botpack.Pickups.AmpPickup'
     DeActivateSound=Sound'Botpack.Pickups.AmpOut'
     Icon=Texture'Botpack.Icons.I_UDamage'
     Physics=PHYS_Rotating
     RemoteRole=ROLE_DumbProxy
     Texture=Texture'Botpack.GoldSkin2'
     Mesh=LodMesh'Botpack.UDamage'
     bMeshEnviroMap=True
}
